<?php
require 'assets/data.php';
require 'assets/config.php';
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <?php
    $sseo = "SELECT content_seo, halaman_seo FROM seo_web WHERE halaman_seo = 'bukti-jp-member'";
    $qseo = mysqli_query($data, $sseo);

    if (mysqli_num_rows($qseo) > 0) {
        $fseo = mysqli_fetch_assoc($qseo);
        $seo = $fseo['content_seo'];
        echo $seo;
    }
    ?>

    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/jquery.paginate.css">
    <link rel="stylesheet" href="css/theme.css">
    <link rel="stylesheet" href="css/styleeditor.css">
    <link href="https://cdn.lineicons.com/4.0/lineicons.css" rel="stylesheet" />
</head>

<body>

    <div class="container my-3">
        <div class="d-flex my-3 align-items-center justify-content-around">
            <div class="logo">
                <img src="<?php echo ftab("logo_web", "web_setting", "logo_web") ?>" alt="logo bukti jackpot <?php echo ftab("link_masukbo", "web_setting", "link_masukbo"); ?>" class="logo">
            </div>

            <div class="search-bar">
                <form id="search-bar">
                    <div class="input-group input-group-sm">
                        <input id="search" name="bukti" type="text" placeholder="Cari Bukti Jackpot.." class="form-control">
                        <button id="search-btn" onclick="removeSearch()" type="button" class="btn btn-info"><i class="lni lni-search-alt"></i></button>
                    </div>
                </form>
            </div>

        </div>

        <div id="search-bukti"></div>

        <?php
        if (isset($_GET['blog'])) {
            $blog = mysqli_real_escape_string($data, $_GET['blog']);

            $sbl = "SELECT * FROM panduan_post WHERE title_slug_panduan = '$blog' AND category_panduan = 'buktijp'";
            $qbl = mysqli_query($data, $sbl);
            echo '<div class="row g-2">';

            if (mysqli_num_rows($qbl) > 0) {


                $fbl = mysqli_fetch_assoc($qbl);
                $title = $fbl['title_panduan'];
                $slug = $fbl['title_slug_panduan'];
                $thumbnail = $fbl['thumbnail_panduan'];
                $content = $fbl['content_panduan'];
                $tanggal = $fbl['tanggal_panduan'];

                echo '<div class="col-12">
                <a class="btn fw-bold btn-info btn-sm" href="/"><small><i class="lni lni-chevron-left-circle"></i></small> Kembali ke Beranda</a>
                    <h1>' . $title . '</h1>
                    <p style="font-size: 0.8rem" class="mb-1 fw-bold text-secondary">' . timeindo($tanggal) . ', ' . date("d", strtotime($tanggal)) . ' ' . monthindo($tanggal) . ' ' . date("Y H:i", strtotime($tanggal)) . ' WIB</p>
                </div>

                <div class="col-xl-9">
                        <div class="card text-dark">
                        <img src="loading.svg" data-src="' . $thumbnail . '" class="card-img-top lazy" alt="' . $slug . '">
                            <div class="card-body">
                                ' . html_entity_decode($content) . '
                            </div>
                        </div>
                </div>';
            } else {
                echo '<div class="col-xl-9">
            <h2 class="title-pp text-center text-danger"><small><i class="fas fa-times-circle"></i></small> 404 Artikel Tidak ditemukan!!</h2>
                    <div class="d-flex justify-content-center">
                        <a class="btn fw-bold btn-primary" href="/">Kembali ke Beranda</a>
                    </div>
            </div>';
            }

            $gar = "SELECT * FROM panduan_post WHERE title_slug_panduan != '$blog' AND category_panduan = 'buktijp' AND panduan_status = '1' ORDER BY tanggal_panduan DESC LIMIT 2";
            $qar = mysqli_query($data, $gar);

            if (mysqli_num_rows($qar) > 0) {
                echo '<div class="col-xl-3">
            <h5 class="text-center">Bukti JP Lainnya:</h5>';
                while ($far = mysqli_fetch_assoc($qar)) {
                    $title = $far['title_panduan'];
                    $slug = $far['title_slug_panduan'];
                    $desc = $far['short_dec_panduan'];
                    $thumbnail = $far['thumbnail_panduan'];
                    $tanggal = $far['tanggal_panduan'];

                    echo '<div class="card mb-2 card-post">
                    <a href="?&blog=' . $slug . '"> <img src="loading.svg" data-src="' . $thumbnail . '" class="card-img-top lazy" alt="' . $slug . '"></a>
                     <div class="card-body">
                         <h5 class="card-title">' . $title . '</h5>
                         <p class="card-text">' . $desc . '</p>
                         <p class="card-text"><small><i class="lni lni-timer"></i> ' . timeindo($tanggal) . ', ' . date("d", strtotime($tanggal)) . ' ' . monthindo($tanggal) . ' ' . date("Y", strtotime($tanggal)) . '</small></p>
                             <div class="d-grid">
                                 <a href="?&blog=' . $slug . '" class="btn btn-sm btn-primary fw-bold"><small><i class="lni lni-cash-app"></i></small> Read More</a>
                             </div>
                     </div>
                 </div>';
                }

                echo '</div>';
            }

            echo '</div>';
        } else {

        ?>

            <div id="title-home">
                <h4 class="text-center text-uppercase my-3 title-home"><i class="lni lni-coin"></i> Bukti Jackpot Lunas <?php echo ftab("link_masukbo", "web_setting", "link_masukbo"); ?></h4>
                <marquee class="teks-berjaalan" direction="left" scrollamount="5"><?php echo ftab("pengumuman_web", "web_setting", "pengumuman_web") ?></marquee>
            </div>

            <div id="all-jackpot" class="row justify-content-center">

                <?php
                $gpanduan = "SELECT * FROM panduan_post WHERE panduan_status = '1' AND category_panduan = 'buktijp' ORDER BY tanggal_panduan DESC";
                $qpanduan = mysqli_query($data, $gpanduan);

                if (mysqli_num_rows($qpanduan) > 0) {
                    while ($fpanduan = mysqli_fetch_assoc($qpanduan)) {
                        $title = $fpanduan['title_panduan'];
                        $slug = $fpanduan['title_slug_panduan'];
                        $desc = $fpanduan['short_dec_panduan'];
                        $thumbnail = $fpanduan['thumbnail_panduan'];
                        $tanggal = $fpanduan['tanggal_panduan'];


                        echo '<div class="col-lg-3 mb-2">
                                                <div class="card card-post h-100 mb-3">
                                                    <div class="row g-0">
                                                        <div class="col-md-12">
                                                            <img src="loading.svg" data-src="' . $thumbnail . '" class="lazy img-post rounded-start h-100" alt="' . $title . '">
                                                        </div>

                                                        <div class="col-md-12">
                                                            <div class="card-body">
                                                                <h5>' . $title . '</h5>
                                                                <p class="time-post text-uppercase"><i class="lni lni-timer"></i> ' . timeindo($tanggal) . ', ' . date("d", strtotime($tanggal)) . ' ' . monthindo($tanggal) . ' ' . date("Y", strtotime($tanggal)) . '</p>
                                                                <p>' . $desc . '</p>

                                                                <div class="d-grid">
                                                                    <a href="?blog=' . $slug . '" class="btn btn-primary fw-bold btn-sm"><i class="lni lni-cash-app"></i></small> Read More</a>
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>';
                    }
                }
                ?>
            </div>

        <?php
        }
        ?>


        <div class="my-2">
            <hr>
            <?php echo ftab("jp_text", "change_text", "jp_text") ?>
        </div>

        <p class="copyright">&copy; Copyright 2014 - <?php echo date("Y") ?> <?php echo ftab("link_masukbo", "web_setting", "link_masukbo"); ?>. All Rights Reserved.</p>
    </div>

    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/jquery.lazy.min.js"></script>
    <script src="js/jquery.paginate.js"></script>
    <script src="js/main.js"></script>

    <?php echo ftab("content_script", "web_setting", "content_script") ?>

</body>

</html>




<!-- TIGER DEVS COPYRIGHT -->