$("#dateresult").datetimepicker({
  format:'Y-m-d',
  timepicker:false,
});

$('#loadingkeluhan').hide();

// Send Keluhan
$("#sendKeluhan").click(function(xxe) {
  xxe.preventDefault();
  var fd = new FormData(document.getElementById("formKeluhan"));
  
  var username = $('#username').val();
  var wa = $('#wa').val();
  var dateKendala = $('#dateresult').val();
  var kendala = $('#kendala').val();
  var isi = $('#isipesan').val();
  var saran = $('#saran').val();

  if(username && wa && dateKendala && kendala && isi && saran){
    $.ajax({
      type: 'POST',
      data: fd,
      contentType: false,
      processData: false,
      url: 'assets/send-keluhan.php',
      beforeSend: function() {
        $('#formKeluhan').hide();
        $('#loadingkeluhan').show();
      },
      complete: function(){
        $('#formKeluhan').show();
        $('#loadingkeluhan').hide();
      },
      success: function(dataResponse){
  
        if(dataResponse == 'error') {
          Swal.fire({
            icon: 'error',
            title: 'Kesalahan Sistem!!' ,
            text: 'Gagal Mengirim Keluhan anda. Mohon dicoba 10 menit lagi. Mohon maaf atas ketidaknyamannya.'
          });
  
        } else if(dataResponse == 'salahgambar') {
              Swal.fire({
                icon: 'error',
                title: 'Format Gambar Salah!!' ,
                text: 'Maaf anda salah mengirim format gambar. Pastikan yang anda kirim hanya file gambar. Terima kasih.'
              });
        } else {

          Swal.fire({
            icon: 'success',
            title: 'Laporan Keluhan dikirim!!',
            showDenyButton: false,
            showCancelButton: false,
            text: 'Berhasil mengirim laporan. Team kami akan segera membalas laporan anda melalui whatsapp aktif anda yang sudah dicantumkan dilaporan ini. Terima kasih.',
            confirmButtonText: 'Buka Keluhan'
          }).then((result) => {
            if (result.isConfirmed) {
              $('#showKeluhan').modal('show');
              $('#contentKeluhan').html(dataResponse);

            } else {
              $('#showKeluhan').modal('show');
              $('#contentKeluhan').html(dataResponse);
            }
          });
        }
  
      }
    });
  } else {
    Swal.fire({
      icon: 'warning',
      title: 'Kolom Kosong!!' ,
      text: 'Mohon maaf. Mohon mengisi semua form yang dibutuhkan agar dapat proses keluhan anda. Terima kasih.'
    });
  }

  return false;

});


function closeTeks(){
  $('#text-berjalan').fadeOut();
  // $('#text-berjalan').remove();
}

$('#formInbox').hide();

var timmer;
function actionKeluhan() {

    var textBtn = document.getElementById("btnInbox");
    if(textBtn.innerText === 'Inbox') {
      textBtn.classList.remove("btn-danger");
      textBtn.classList.add("btn-warning");
      textBtn.innerText = 'Kembali';
      $('#formKeluhan').hide();
      $('#formInbox').show();
      $('#title-keluhan').text('Inbox Keluhan');

     timmer = setInterval(findKeluhan, 2000);

    } else {
      textBtn.classList.remove("btn-warning");
      textBtn.classList.add("btn-danger");
      textBtn.innerText = 'Inbox';
      $('#title-keluhan').text('Laporkan Masalah');

      $('#formKeluhan').show();
      $('#formInbox').hide();
      clearInterval(timmer);
    }
}

function findKeluhan() {
var kode = $('#kodekeluhan').val();

 $.ajax({
    type: 'GET',
    url: 'assets/components/show-inbox.php',
    timeout: 1000,
    cache: false,
    data: {
      'kodekeluhan': kode
    },
    success: function(kodeRes){

          var checkFocus = function() {
          var container = $('#content-keluhan');
          var height = container.height();
          var scrollHeight = container[0].scrollHeight;
          var st = container.scrollTop();
          var sum = scrollHeight - height - 32;
          if(st >= sum) {
              return true;
          } else {
              return false;
          }
      }

      if(checkFocus()) {
        $('#content-keluhan').html(kodeRes);
              var objDiv = document.getElementById("content-keluhan");
              objDiv.scrollTop = objDiv.scrollHeight;
      } else {
        $('#content-keluhan').html(kodeRes);
      }

    }
  });

  return false;
}

function removeKode() {
  $('#kodekeluhan').val('');
}

// Copy Code Keluhan
async function copyCode() {
  // Get the text field
  var copyText = document.getElementById('kodebaru').innerHTML;

  // Copy the text inside the text field
  await parent.navigator.clipboard.writeText(copyText);
  
  // Alert the copied text
  alert("Berhasil Salin Kode Keluhan: " + copyText);
}

$('#kotakpesan').keypress(function (e) {
  var key = e.which;
  if(key == 13)  // the enter key code
   {
     $('#sendInbox').click();
     return false;  
   }
 });

$("#sendInbox").click(function(z) {
  z.preventDefault();
  var zr = new FormData(document.getElementById("inboxSend"));
  // var kodeInbox = $('#kodekeluhan').val();
  // var kotakPesan = $('#kotakpesan').val();

  $.ajax({
    type: 'POST',
    data: zr,
    contentType: false,
    processData: false,
    url: 'assets/components/send-inbox.php',
    success: function(responseInbox) {
        if(responseInbox == 'empty-code') {
          Swal.fire({
            icon: 'warning',
            title: 'Kolom Kode atau Pesan Kosong!!' ,
            text: 'Mohon maaf. Mohon mengisi semua form yang dibutuhkan agar dapat proses Inbox anda. Terima kasih.'
          });

        } else if(responseInbox == 'no-code') {
          Swal.fire({
            icon: 'error',
            title: 'Kode Tidak ditemukan!!' ,
            text: 'Mohon maaf. Kode yang anda isi tidak ada terdaftar disistem kami. Mohon diperiksa kembali dan dicoba ulang, Terima Kasih.'
          });

        } else if(responseInbox == 'error') {
          Swal.fire({
            icon: 'error',
            title: 'Sistem Sedang Bermasalah!!' ,
            text: 'Mohon maaf atas ketidaknyamannya, Mohon dicoba sesaat lagi, Terima Kasih.'
          });

        } else if(responseInbox == 'salahgambar') {
          Swal.fire({
            icon: 'error',
            title: 'Format Gambar Salah!!' ,
            text: 'Maaf anda salah mengirim format gambar. Pastikan yang anda kirim hanya file gambar. Terima kasih.'
          });
          
        } else {
          $('#kotakpesan').val('');
          $('#sendgambar').val('');
        }
    }

  })
  
});